(function(factory){if(typeof define==="function"&&define.amd){define(["jquery"],function($){factory($,window,document)})}else{factory(jQuery,window,document)}})(function($,window,document,undefined){"use strict";var pluginName="countrySelect",id=1,defaults={defaultCountry:"",defaultStyling:"inside",onlyCountries:[],preferredCountries:["us","gb"]},keys={UP:38,DOWN:40,ENTER:13,ESC:27,PLUS:43,A:65,Z:90},windowLoaded=false;$(window).on("load",function(){windowLoaded=true});function Plugin(element,options){this.element=element;this.options=$.extend({},defaults,options);this._defaults=defaults;this.ns="."+pluginName+id++;this._name=pluginName;this.init()}Plugin.prototype={init:function(){this._processCountryData();this._generateMarkup();this._setInitialState();this._initListeners()},_processCountryData:function(){this._setInstanceCountryData();this._setPreferredCountries()},_setInstanceCountryData:function(){var that=this;if(this.options.onlyCountries.length){var newCountries=[];$.each(this.options.onlyCountries,function(i,countryCode){var countryData=that._getCountryData(countryCode,true);if(countryData){newCountries.push(countryData)}});this.countries=newCountries}else{this.countries=allCountries}},_setPreferredCountries:function(){var that=this;this.preferredCountries=[];$.each(this.options.preferredCountries,function(i,countryCode){var countryData=that._getCountryData(countryCode,false);if(countryData){that.preferredCountries.push(countryData)}})},_generateMarkup:function(){this.countryInput=$(this.element);var mainClass="country-select";if(this.options.defaultStyling){mainClass+=" "+this.options.defaultStyling}this.countryInput.wrap($("<div>",{class:mainClass}));var flagsContainer=$("<div>",{class:"flag-dropdown"}).insertAfter(this.countryInput);var selectedFlag=$("<div>",{class:"selected-flag"}).appendTo(flagsContainer);this.selectedFlagInner=$("<div>",{class:"flag"}).appendTo(selectedFlag);$("<div>",{class:"arrow"}).appendTo(this.selectedFlagInner);this.countryList=$("<ul>",{class:"country-list v-hide"}).appendTo(flagsContainer);if(this.preferredCountries.length){this._appendListItems(this.preferredCountries,"preferred");$("<li>",{class:"divider"}).appendTo(this.countryList)}this._appendListItems(this.countries,"");this.countryCodeInput=$("#"+this.countryInput.attr("id")+"_code");if(!this.countryCodeInput){this.countryCodeInput=$('<input type="hidden" id="'+this.countryInput.attr("id")+'_code" name="'+this.countryInput.attr("name")+'_code" value="" />');this.countryCodeInput.insertAfter(this.countryInput)}this.dropdownHeight=this.countryList.outerHeight();this.countryList.removeClass("v-hide").addClass("hide");this.countryListItems=this.countryList.children(".country")},_appendListItems:function(countries,className){var tmp="";$.each(countries,function(i,c){tmp+='<li class="country '+className+'" data-country-code="'+c.iso2+'">';tmp+='<div class="flag '+c.iso2+'"></div>';tmp+='<span class="country-name">'+c.name+"</span>";tmp+="</li>"});this.countryList.append(tmp)},_setInitialState:function(){var flagIsSet=false;if(this.countryInput.val()){flagIsSet=this._updateFlagFromInputVal()}var selectedCode=this.countryCodeInput.val();if(selectedCode){this.selectCountry(selectedCode)}if(!flagIsSet){var defaultCountry;if(this.options.defaultCountry){defaultCountry=this._getCountryData(this.options.defaultCountry,false);if(!defaultCountry){defaultCountry=this.preferredCountries.length?this.preferredCountries[0]:this.countries[0]}}else{defaultCountry=this.preferredCountries.length?this.preferredCountries[0]:this.countries[0]}this.selectCountry(defaultCountry.iso2)}},_initListeners:function(){var that=this;this.countryInput.on("keyup"+this.ns,function(){that._updateFlagFromInputVal()});var selectedFlag=this.selectedFlagInner.parent();selectedFlag.on("click"+this.ns,function(e){if(that.countryList.hasClass("hide")&&!that.countryInput.prop("disabled")){that._showDropdown()}});this.countryInput.on("blur"+this.ns,function(){if(that.countryInput.val()!=that.getSelectedCountryData().name){that.setCountry(that.countryInput.val())}that.countryInput.val(that.getSelectedCountryData().name)})},_focus:function(){this.countryInput.focus();var input=this.countryInput[0];if(input.setSelectionRange){var len=this.countryInput.val().length;input.setSelectionRange(len,len)}},_showDropdown:function(){this._setDropdownPosition();var activeListItem=this.countryList.children(".active");this._highlightListItem(activeListItem);this.countryList.removeClass("hide");this._scrollTo(activeListItem);this._bindDropdownListeners();this.selectedFlagInner.children(".arrow").addClass("up")},_setDropdownPosition:function(){var inputTop=this.countryInput.offset().top,windowTop=$(window).scrollTop(),dropdownFitsBelow=inputTop+this.countryInput.outerHeight()+this.dropdownHeight<windowTop+$(window).height(),dropdownFitsAbove=inputTop-this.dropdownHeight>windowTop;var cssTop=!dropdownFitsBelow&&dropdownFitsAbove?"-"+(this.dropdownHeight-1)+"px":"";this.countryList.css("top",cssTop)},_bindDropdownListeners:function(){var that=this;this.countryList.on("mouseover"+this.ns,".country",function(e){that._highlightListItem($(this))});this.countryList.on("click"+this.ns,".country",function(e){that._selectListItem($(this))});var isOpening=true;$("html").on("click"+this.ns,function(e){if(!isOpening){that._closeDropdown()}isOpening=false});$(document).on("keydown"+this.ns,function(e){e.preventDefault();if(e.which==keys.UP||e.which==keys.DOWN){that._handleUpDownKey(e.which)}else if(e.which==keys.ENTER){that._handleEnterKey()}else if(e.which==keys.ESC){that._closeDropdown()}else if(e.which>=keys.A&&e.which<=keys.Z){that._handleLetterKey(e.which)}})},_handleUpDownKey:function(key){var current=this.countryList.children(".highlight").first();var next=key==keys.UP?current.prev():current.next();if(next.length){if(next.hasClass("divider")){next=key==keys.UP?next.prev():next.next()}this._highlightListItem(next);this._scrollTo(next)}},_handleEnterKey:function(){var currentCountry=this.countryList.children(".highlight").first();if(currentCountry.length){this._selectListItem(currentCountry)}},_handleLetterKey:function(key){var letter=String.fromCharCode(key);var countries=this.countryListItems.filter(function(){return $(this).text().charAt(0)==letter&&!$(this).hasClass("preferred")});if(countries.length){var highlightedCountry=countries.filter(".highlight").first(),listItem;if(highlightedCountry&&highlightedCountry.next()&&highlightedCountry.next().text().charAt(0)==letter){listItem=highlightedCountry.next()}else{listItem=countries.first()}this._highlightListItem(listItem);this._scrollTo(listItem)}},_updateFlagFromInputVal:function(){var that=this;var value=this.countryInput.val().replace(/(?=[() ])/g,"\\");if(value){var countryCodes=[];var matcher=new RegExp("^"+value,"i");for(var i=0;i<this.countries.length;i++){if(this.countries[i].name.match(matcher)){countryCodes.push(this.countries[i].iso2)}}var alreadySelected=false;$.each(countryCodes,function(i,c){if(that.selectedFlagInner.hasClass(c)){alreadySelected=true}});if(!alreadySelected){this._selectFlag(countryCodes[0]);this.countryCodeInput.val(countryCodes[0]).trigger("change")}return true}return false},_highlightListItem:function(listItem){this.countryListItems.removeClass("highlight");listItem.addClass("highlight")},_getCountryData:function(countryCode,ignoreOnlyCountriesOption){var countryList=ignoreOnlyCountriesOption?allCountries:this.countries;for(var i=0;i<countryList.length;i++){if(countryList[i].iso2==countryCode){return countryList[i]}}return null},_selectFlag:function(countryCode){if(!countryCode){return false}this.selectedFlagInner.attr("class","flag "+countryCode);var countryData=this._getCountryData(countryCode);this.selectedFlagInner.parent().attr("title",countryData.name);var listItem=this.countryListItems.children(".flag."+countryCode).first().parent();this.countryListItems.removeClass("active");listItem.addClass("active")},_selectListItem:function(listItem){var countryCode=listItem.attr("data-country-code");this._selectFlag(countryCode);this._closeDropdown();this._updateName(countryCode);this.countryInput.trigger("change");this.countryCodeInput.trigger("change");this._focus()},_closeDropdown:function(){this.countryList.addClass("hide");this.selectedFlagInner.children(".arrow").removeClass("up");$(document).off("keydown"+this.ns);$("html").off("click"+this.ns);this.countryList.off(this.ns)},_scrollTo:function(element){if(!element||!element.offset()){return}var container=this.countryList,containerHeight=container.height(),containerTop=container.offset().top,containerBottom=containerTop+containerHeight,elementHeight=element.outerHeight(),elementTop=element.offset().top,elementBottom=elementTop+elementHeight,newScrollTop=elementTop-containerTop+container.scrollTop();if(elementTop<containerTop){container.scrollTop(newScrollTop)}else if(elementBottom>containerBottom){var heightDifference=containerHeight-elementHeight;container.scrollTop(newScrollTop-heightDifference)}},_updateName:function(countryCode){this.countryCodeInput.val(countryCode).trigger("change");this.countryInput.val(this._getCountryData(countryCode).name)},getSelectedCountryData:function(){var countryCode=this.selectedFlagInner.attr("class").split(" ")[1];return this._getCountryData(countryCode)},selectCountry:function(countryCode){countryCode=countryCode.toLowerCase();if(!this.selectedFlagInner.hasClass(countryCode)){this._selectFlag(countryCode);this._updateName(countryCode)}},setCountry:function(country){this.countryInput.val(country);this._updateFlagFromInputVal()},destroy:function(){this.countryInput.off(this.ns);this.selectedFlagInner.parent().off(this.ns);var container=this.countryInput.parent();container.before(this.countryInput).remove()}};$.fn[pluginName]=function(options){var args=arguments;if(options===undefined||typeof options==="object"){return this.each(function(){if(!$.data(this,"plugin_"+pluginName)){$.data(this,"plugin_"+pluginName,new Plugin(this,options))}})}else if(typeof options==="string"&&options[0]!=="_"&&options!=="init"){var returns;this.each(function(){var instance=$.data(this,"plugin_"+pluginName);if(instance instanceof Plugin&&typeof instance[options]==="function"){returns=instance[options].apply(instance,Array.prototype.slice.call(args,1))}if(options==="destroy"){$.data(this,"plugin_"+pluginName,null)}});return returns!==undefined?returns:this}};$.fn[pluginName].getCountryData=function(){return allCountries};$.fn[pluginName].setCountryData=function(obj){allCountries=obj};var ii=0;var cc=[];var allCountries=$.each(uwp_country_data,function(i,c){cc[ii]={name:c,iso2:i};ii++});allCountries=cc});