<?php

$prefix = 'eventkoi_event_single_';

$design_options = [
	$prefix . 'hero_title_font' => [
		'type' => 'ct-typography',
		'label' => __( 'Title Font', 'blocksy' ),
		'value' => blocksy_typography_default_values([
			'size' => '30px'
		]),
		'design' => 'block',
		'sync' => 'live'
	],

	$prefix . 'hero_title_font_color' => [
		'label' => __( 'Title Font Color', 'blocksy' ),
		'type'  => 'ct-color-picker',
		'design' => 'inline',
		'sync' => 'live',

		'value' => [
			'default' => [
				'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
			],
		],

		'pickers' => [
			[
				'title' => __( 'Initial', 'blocksy' ),
				'id' => 'default',
				'inherit' => 'var(--theme-heading-1-color, var(--theme-headings-color))'
			],
		],
	],

	$prefix . 'hero_categories_font' => [
		'type' => 'ct-typography',
		'label' => __( 'Categories Font', 'blocksy' ),
		'value' => blocksy_typography_default_values([
			'size' => '14px',
			'variation' => 'n5',
			'line-height' => '1.3',
			// 'text-transform' => 'uppercase',
		]),
		'design' => 'block',
		'sync' => 'live',
		'divider' => 'top:full',
	],

	$prefix . 'hero_categories_colors' => [
		'label' => __( 'Categories Font Color', 'blocksy' ),
		'type'  => 'ct-color-picker',
		'design' => 'inline',
		'sync' => 'live',

		'value' => [
			'default' => [
				'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
			],

			'hover' => [
				'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
			],
		],

		'pickers' => [
			[
				'title' => __( 'Initial', 'blocksy' ),
				'id' => 'default',
				'inherit' => 'var(--theme-text-color)'
			],

			[
				'title' => __( 'Hover', 'blocksy' ),
				'id' => 'hover',
				'inherit' => 'var(--theme-link-hover-color)'
			],
		],
	],

	$prefix . 'hero_actions_font' => [
		'type' => 'ct-typography',
		'label' => __( 'Event Actions Font', 'blocksy' ),
		'value' => blocksy_typography_default_values([
			'size' => '15px',
			'variation' => 'n4',
			'line-height' => '1.4',
			// 'text-transform' => 'uppercase',
		]),
		'design' => 'block',
		'sync' => 'live',
		'divider' => 'top:full',
	],

	$prefix . 'hero_actions_colors' => [
		'label' => __( 'Event Actions Font Color', 'blocksy' ),
		'type'  => 'ct-color-picker',
		'design' => 'inline',
		'sync' => 'live',

		'value' => [
			'default' => [
				'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
			],

			'hover' => [
				'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
			],
		],

		'pickers' => [
			[
				'title' => __( 'Initial', 'blocksy' ),
				'id' => 'default',
				'inherit' => 'var(--theme-text-color)'
			],

			[
				'title' => __( 'Hover', 'blocksy' ),
				'id' => 'hover',
				'inherit' => 'var(--theme-link-hover-color)'
			],
		],
	],

	$prefix . 'hero_title_rating_font' => [
		'type' => 'ct-typography',
		'label' => __( 'Rating Font', 'blocksy' ),
		'value' => blocksy_typography_default_values([
			'size' => '14px',
			'variation' => 'n4',
			// 'text-transform' => 'uppercase',
		]),
		'design' => 'block',
		'sync' => 'live',
		'divider' => 'top:full',
	],

	$prefix . 'hero_title_rating_font_color' => [
		'label' => __( 'Rating Font Color', 'blocksy' ),
		'type'  => 'ct-color-picker',
		'design' => 'inline',
		'sync' => 'live',

		'value' => [
			'default' => [
				'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
			],
		],

		'pickers' => [
			[
				'title' => __( 'Initial', 'blocksy' ),
				'id' => 'default',
				'inherit' => 'var(--theme-text-color)'
			],
		],
	],

	$prefix . 'hero_title_star_rating_color' => [
		'label' => __( 'Star Rating Color', 'blocksy' ),
		'type'  => 'ct-color-picker',
		'design' => 'inline',
		'divider' => 'top',
		'sync' => 'live',

		'value' => [
			'default' => [
				'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
			],
		],

		'pickers' => [
			[
				'title' => __( 'Initial', 'blocksy' ),
				'id' => 'default',
				'inherit' => '#ED9700'
			],
		],
	],

];

$options = [
	'eventkoi_event_single_options' => [
		'type' => 'ct-options',
		'inner-options' => [
			blocksy_get_options('general/page-title', [
				'prefix' => 'eventkoi_event_single',
				'is_single' => true,
				'is_cpt' => true,
				'has_hero_elements' => false,
				'enabled_label' => blocksy_safe_sprintf(
					__('%s Title', 'blocksy'),
					'Event'
				),
				'design_options' => $design_options,
				'location_name' => __('Event Single', 'blocksy')
			]),

			blocksy_rand_md5() => [
				'type' => 'ct-title',
				'label' => __( 'Event Structure', 'blocksy' ),
			],

			blocksy_rand_md5() => [
				'title' => __( 'General', 'blocksy' ),
				'type' => 'tab',
				'options' => [
					blocksy_get_options('single-elements/structure', [
						'default_structure' => 'type-4',
						'prefix' => 'eventkoi_event_single',
					]),
				],
			],

			blocksy_rand_md5() => [
				'title' => __( 'Design', 'blocksy' ),
				'type' => 'tab',
				'options' => [

					blocksy_get_options('single-elements/structure-design', [
						'prefix' => 'eventkoi_event_single',
					])

				],
			],

		]
	]
];

